class Revenge extends Mutator config(UT_Revenge);

var config int scoreBonus;              // Bonus score received when a pawn takes revenge.
var config bool broadcastRevenge;       // Broadcast revenge message to all players?

var localized string revengeMessage;    // Broadcasted revenge message.

var Pawn victims[32];                   // Pawns that were killed.
var Pawn killers[32];                   // The pawn that killed the other pawn (victims).

const maxPawns = 32;                    // Maximum number of pawns that can be stored.

function scoreKill(Pawn killer, Pawn victim) {
	local int index;
	local bool bFound;
	local int freeIndex;
	
	// Don't do anything if one of the pawns is none, or it was a suicide.
	if (killer != none && victim != none && killer != victim &&
	    killer.playerReplicationInfo != none && victim.playerReplicationInfo != none) {
		
		// Get victim list index for the victim.
		freeIndex = -1;
		while (!bFound && index < maxPawns) {
			// Found victim index?
			if (victims[index] == victim) {
				// Yes.
				 bFound = true;
			} else {
				// No, continue with next one.
				if (victims[index] == none && freeIndex < 0) {
					// Remember this free slot.
					freeIndex = index;
				}
				index++;
			}
		}
		
		// Update victim and killer lists.
		if (bFound) {
			killers[index] = killer;
		} else if (freeIndex >= 0) {
			victims[freeIndex] = victim;
			killers[freeIndex] = killer;
		}
		
		// Get victim list index for the killer.
		bFound = false;
		index = 0;
		while (!bFound && index < maxPawns) {
			// Found victim index?
			if (victims[index] == killer) {
				// Yes.
				bFound = true;
			} else {
				// No, continue with next one.
				index++;
			}
		}
		
		// Check for revenge.
		if (bFound && killers[index] == victim) {
			// Oh yeah, this one has taken revenge!
			killer.playerReplicationInfo.score += scoreBonus;
			
			// Broadcast revenge message.
			if (broadcastRevenge) {
				broadcastMessage(format(revengeMessage,
				                        killer.playerReplicationInfo.playerName,
				                        victim.playerReplicationInfo.playerName));
			}
			
			// Send revenge message to killer.
			if (killer.isA('PlayerPawn')) {
				killer.receiveLocalizedMessage(class'RevengeMessage', , killer.playerReplicationInfo, victim.playerReplicationInfo);
			}
			
			// Reset last killer, we don't want players to revenge twice on the same person.
			killers[index] = none;
		}
		
	}
	
	// Allow other mutators to do their job.
	if (nextMutator != none) {
		nextMutator.scoreKill(killer, victim);
	}
	
}

static function string replace(string source, string oldStr, string newStr) {
	local bool bDone;
	local int subStrIndex;
	local string result;
	local string strLeft;
	
	strLeft = source;
	
	// Replace each occurrence of oldStr with newStr.
	while (!bDone) {
		
		// Find index of oldStr in the part not examined yet.
		subStrIndex = instr(strLeft, oldStr);
		
		// Update examined and unexamined parts.
		if (subStrIndex < 0) {
			bDone = true;
			result = result $ strLeft;
		} else {
			result = result $ left(strLeft, subStrIndex) $ newStr;
			strLeft = mid(strLeft, subStrIndex + len(oldStr));
		}
	}
	
	// Return the filtered string.
	return result;
}

static function string format(string source, optional string str1, optional string str2, optional string str3, optional string str4) {
	local string formattedStr;
	
	formattedStr = replace(source, "%1", str1);
	formattedStr = replace(formattedStr, "%2", str2);
	formattedStr = replace(formattedStr, "%3", str3);
	formattedStr = replace(formattedStr, "%4", str4);
	
	return formattedStr;
}



/***************************************************************************************************
 *
 *  $DESCRIPTION  Default properties block.
 *
 **************************************************************************************************/

defaultproperties
{
     scoreBonus=5
     broadcastRevenge=True
     RevengeMessage="%1 had sweet revenge on %2."
}
